REIEvents.information(info => {
    info.addItem('endrem:cold_eye', 'Cold Eye', ['Cure the Zombie Villager trapped under an igloo, and trade with them.'])
    info.addItem('endrem:lost_eye', 'Lost Eye', ['Obtain the "Hero of the Village" effect, and give a Villager a Netherite-Emerald Ingot.'])
    info.addItem('endrem:nether_eye', 'Nether Eye', ['Summon a Blackstone Golem using a Soul Pedestal, and defeat it.'])
    info.addItem('endrem:old_eye', 'Old Eye', ['Rare loot in FTB Dungeons chests.'])
    info.addItem('endrem:rogue_eye', 'Rogue Eye', ['Loot in Woodland Mansion chests.'])
    info.addItem('endrem:cursed_eye', 'Cursed Eye', ['Loot in Pyramids.',' ','Obtaining will curse the player, summoning mobs and other effects.',' ','Lift the curse by defeating the Pharoah.'])
    info.addItem('endrem:evil_eye', 'Evil Eye', ['Throw a Blazing Geode on a Blaze Spawner and defeat the boss that\'s summoned.'])
    info.addItem('endrem:magical_eye', 'Magical Eye', ['Blow the Magical Goat Horn at a mountain peak.'])
    info.addItem('endrem:wither_eye', 'Wither Eye', ['Drops from the Wither.'])
    info.addItem('endrem:witch_eye', 'Witch Eye', ['Visit a Mushroom Fields biome and speak to a Fungus, and it will ask for a specific Flower.', ' ','Bring it that Flower and it wlil give you its Spores.',' ','Brew this into a potion and use it on a Witch in their Hut to transform them. Defeat them to get their Eye.'])
    info.addItem('endrem:undead_eye', 'Undead Eye', ['Summon and defeat the Necromancer in a Soul Sand Valley.'])
    info.addItem('endrem:exotic_eye', 'Exotic Eye', ['Speak with an Allay, and it will ask for a specific Coral.',' ','Bring the Allay that Coral it will give you the Eye.'])
    info.addItem('endrem:cryptic_eye', 'Cryptic Eye', [''])

    info.addItem('lote:dull_eye', 'Dull Eye', ['Can be bought from Wandering Traders'])
    info.addItem('lote:blazing_geode', 'Blazing Geode', ['Can be bought from Clerics'])
    info.addItem('lote:guardian_fragment', 'Guardian Fragments', ['Drops from Elder Guardians'])
    info.addItem('lote:goat_horn', 'Magical Goat Horn', ['When a Goat rams certain blocks, the resulting Horn has a 10% chance of being Magical.'])
    info.addItem('lote:mushroom_spore', 'Mushroom Spore', ['Given by Fungus in exchange for a flower'])

    // info.addItem('indrev:modular_core_activated','Core of Modularity',[
    //     'Place a Capsule, and insert a Core of Modularity (Uncharged).',
    //     ' ',
    //     'With EXACTLY three blocks in-between, place a Laser Emitter aimed at the Capsule.',
    //     ' ',
    //     'Provide the Laser Emitter with Lazuli Flux, and give it a Redstone signal.',
    //     ' ',
    //     'After the Capsule has received 100M LF, turn off the Laser and take out the charged Core.',
    //     ' ',
    //     'Multipler Laser Emitters can be used per Capsule, to charge it faster.'
    // ])

    info.addItem('adventurez:piglin_flag_block','Piglin Flag',[
        'Uncommon drop from the Piglin Beast, which can be summoned when Piglins are killed.'
    ])

    info.addItem(Item.of('spirit:soul_crystal_shard', '{EntityType:"minecraft:iron_golem"}'),'Filling Soul Crystal Shards',[
        'Kill a mob while holding a Soul Crystal Shard in your inventory to attune it to that mob.'
    ])

    info.addItem('echoingdepths:warden_heart', 'Warden Heart', 'Drops from the Warden')
    info.addItem('endrem:undead_soul','Undead Soul', 'Drops from Skeletons and Wither Skeletons that spawn in Soul Sand Valleys')
    info.addItem('consistency_plus:withered_bone','Withered Bone','Drops from Wither Skeletons')

    info.addItem(Item.of('minecraft:white_banner', '{BlockEntityTag:{Patterns:[{Color:9,Pattern:"mr"},{Color:8,Pattern:"bs"},{Color:7,Pattern:"cs"},{Color:8,Pattern:"bo"},{Color:15,Pattern:"ms"},{Color:8,Pattern:"hh"},{Color:8,Pattern:"mc"},{Color:15,Pattern:"bo"}],id:"minecraft:banner"},HideFlags:32,display:{Name:\'{"color":"gold","translate":"block.minecraft.ominous_banner"}\'}}'),'Ominous Banner',[
        'Drops from Illager Captains that are not part of a raid.',
        ' ',
        'The above also gives the "Bad Omen" effect.'
    ])
    info.addItem('explorerscompass:explorerscompass', "Explorer's Compass", "Obtainable by trading with a Lvl 5 Cartographer.")
    info.addItem('lote:magic_dragon_scale', 'Magic Dragon Scale', ['A special Magic Dragon Scale.','','The Legend sais, this Scale can be used on Dragons to change their appearance.'])
    info.addItem('indrev:cabinet', 'Cabinet', ['dont use this as a storage compartment, it will void your items if broken'])


})

REIEvents.add('item', item => {
    item.add(Item.of('minecraft:white_banner', '{BlockEntityTag:{Patterns:[{Color:9,Pattern:"mr"},{Color:8,Pattern:"bs"},{Color:7,Pattern:"cs"},{Color:8,Pattern:"bo"},{Color:15,Pattern:"ms"},{Color:8,Pattern:"hh"},{Color:8,Pattern:"mc"},{Color:15,Pattern:"bo"}],id:"minecraft:banner"},HideFlags:32,display:{Name:\'{"color":"gold","translate":"block.minecraft.ominous_banner"}\'}}'))
})

REIEvents.hide('item', item =>{
    const list = [
        'openblocks:elevator_block',
        'kibe:entangled_chest',
        'kibe:obsidian_sand',
        'kibe:wither_proof_block',
        'kibe:wither_proof_sand',
        'kibe:wither_proof_glass',
        'kibe:chunk_loader',
        'kibe:angel_ring'
    ]
    list.forEach(listItem =>{
        item.hide(listItem)
    })

    Ingredient.of('#consistency_plus:material/ice').stacks.forEach(i=>{
        item.hide(i)
    })

})


REIEvents.removeCategories(event => {
    event.remove("minecraft:plugins/tag")
    event.remove("ae2:attunement")

  })

ItemEvents.tooltip(tooltip => {
    tooltip.add('openblocks:elevator_block', 'Deprecated, please use the new kibe elevator blocks')
    tooltip.add('kibe:golden_lasso', 'Can only hold passive animals.')
    tooltip.add('kibe:cursed_lasso', 'Can hold aggressive entities but will add the curse effect to them upon release.')
    tooltip.add('kibe:diamond_lasso', 'Can hold almost any entity without debuffs')

})
// /^().*()$/

REIEvents.groupEntries(e => {


    e.groupItems('kibe:rei_groups/gliders', 'Gliders', [/^(kibe:).*(glider)$/])
    e.groupItems('kibe:rei_groups/sleeping_bag', 'Sleeping Bags', [/^(kibe:).*(_sleeping_bag)$/])
    e.groupItems('kibe:rei_groups/elevator', 'Elevators', [/^(kibe:).*(elevator)$/])
    e.groupItems('kibe:rei_groups/rune', 'Runes', [/^(kibe:).*(rune)$/])
    e.groupItems('kibe:rei_groups/cobblegen', 'Cobblestone Generator', [/^(kibe:cobblestone_generator).*/])
    e.groupItems('kibe:rei_groups/basaltgen', 'Basalt Generator', [/^(kibe:basalt).*/])
    e.groupItems('kubejs:rei_groups/wools', 'Wools', [/_wool/])
    e.groupItems('minecraft:rei_groups/carpets', 'Carpets', [/_carpet/])
    e.groupItems('minecraft:rei_groups/stripped_log', 'Stripped Logs', [/^(minecraft:stripped).*(_log)$/])
    e.groupItems('minecraft:rei_groups/vanilla_logs', 'Vanilla Logs', [/^minecraft:(?!stripped).*(log)$/])
    e.groupItems('minecraft:rei_groups/leaves', 'Vanilla Leaves', [/^(minecraft:).*(Leaves)$/])
    e.groupItems('minecraft:rei_groups/glass', 'Stained Glass', [/^(minecraft:).*(stained_glass)$/])
    e.groupItems('minecraft:rei_groups/concrete', 'Concrete Colors', [/^(minecraft:).*(concrete)$/])
    e.groupItems('minecraft:rei_groups/concrete_powder', 'Concrete Powder', [/^(minecraft:).*(concrete_powder)$/])
    e.groupItems('minecraft:rei_groups/bundles', 'Bundles', '#c:bundles')
    



    const stoneCutterGroup = [
        'packed_mud', 'smooth_mud', 'mud', 'smooth_snow', 'snow', 'clay', 'smooth_clay', 'smooth_blue_ice', 'blue_ice', 'smooth_packed_ice', 'packed_ice', 'smooth_ice', 'ice'
    ]
    stoneCutterGroup.forEach(type => {
        e.groupItems(`consistency_plus:rei_groups/${type}`, `${type} Group`, `#consistency_plus:stonecutter_recipes/stonecutter_recipe_${type}`)

    })
    const group = [
        'stone', 'smooth_stone', 'andesite', 'diorite', 'granite', 'calcite', 'dripstone', 'tuff',
        'sandstone', 'red_sandstone', 'soul_sandstone', 'blackstone', 'quartz', 'basalt', 'end_stone', 'deepslate',
        'obsidian', 'crying_obsdian', 'purpur', 'prismarine', 'dark_prismarine', 'netherrack', 'crimson_wart',
        'warped_wart', 'bone', 'withered_bone', 'copper', 'terracotta', 'glowstone', 'tinted_glass', 'glazed_terracotta',
    ]
    group.forEach(type =>{
        e.groupItems(`consistency_plus:rei_groups/${type}`, `${type} Group`, `#consistency_plus:material/${type}`)
    })
    e.groupItems(`consistency_plus:rei_groups/bricks`, `Bricks`, `#consistency_plus:ingots/brick`)

    
    const consistencyGroup = [
        'concrete_bricks_block', 'concrete_brick_slab', 'concrete_brick_stairs','concrete_brick_wall', 'concrete_brick_gate', 'concrete_tiles_block', 
        'concrete_tile_slab', 'concrete_tile_stairs', 'concrete_tile_wall', 'concrete_tile_gate', 'concrete_slab', 'concrete_stairs',
        'concrete_wall', 'concrete_gate', 'concrete_pillar', 'concrete_corner_pillar', 'carved_concrete', 'chiseled_concrete',
        'polished_concrete_block', 'polished_concrete_slab', 'polished_concrete_stairs', 'polished_concrete_wall', 
        'polished_concrete_gate', 'cut_concrete_block', 'cut_concrete_slab', 'cut_concrete_stairs', 'cut_concrete_wall', 'cut_concrete_gate',
        'smooth_concrete_block', 'smooth_concrete_slab', 'smooth_concrete_stairs', 'smooth_concrete_wall', 'smooth_concrete_gate'
    ]
    consistencyGroup.forEach(type => {
        e.groupItems(`consistency_plus:rei_groups/${type}`, `${type} Group`, `#consistency_plus:material/concrete/${type}`)
    })

    const powah = [
        'energy_cell', 'ender_cell', 'energy_cable', 'ender_gate', 'energizing_rod', 'furnator', 'magmator',
        'thermo_generator', 'solar_panel', 'reactor', 'player_transmitter', 'energy_hopper', 'energy_discharger', 'battery']
    powah.forEach(type => {
        e.groupItems(`powah:rei_groups/${type}`, `${type} Group`, [
            `powah:${type}_starter`,
            `powah:${type}_basic`,
            `powah:${type}_hardened`,
            `powah:${type}_blazing`,
            `powah:${type}_niotic`,
            `powah:${type}_spirited`,
            `powah:${type}_nitro`])  
        
    })
})


